/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.BadCredentialsException;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.JwtVerifier;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.KeyProvider;
import com.floragunn.dlic.util.Roles;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.user.Attributes;
import com.floragunn.searchguard.user.AuthCredentials;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public abstract class AbstractHTTPJwtAuthenticator
implements LegacyHTTPAuthenticator {
    private static final Logger log = LogManager.getLogger(AbstractHTTPJwtAuthenticator.class);
    private static final String BEARER = "bearer ";
    private KeyProvider keyProvider;
    private JwtVerifier jwtVerifier;
    private final String jwtHeaderName;
    private final String jwtUrlParameter;
    private final String subjectKey;
    private final Pattern subjectPattern;
    private final String rolesKey;
    private final String jsonSubjectPath;
    private final String jsonRolesPath;
    private Configuration jsonPathConfig;
    private Map<String, JsonPath> attributeMapping;

    protected AbstractHTTPJwtAuthenticator(Settings settings, Path configPath) {
        this.jwtUrlParameter = settings.get("jwt_url_parameter");
        this.jwtHeaderName = settings.get("jwt_header", "Authorization");
        this.rolesKey = settings.get("roles_key");
        this.subjectKey = settings.get("subject_key");
        this.jsonRolesPath = settings.get("roles_path");
        this.jsonSubjectPath = settings.get("subject_path");
        this.subjectPattern = AbstractHTTPJwtAuthenticator.getSubjectPattern(settings);
        try {
            this.keyProvider = this.initKeyProvider(settings, configPath);
            this.jwtVerifier = new JwtVerifier(this.keyProvider);
        }
        catch (Exception e) {
            log.error("Error creating JWT authenticator: " + e + ". JWT authentication will not work", (Throwable)e);
        }
        if (this.subjectKey != null && this.jsonSubjectPath != null || this.rolesKey != null && this.jsonRolesPath != null) {
            throw new IllegalStateException("Both, subject_key and subject_path or roles_key and roles_path have simultaneously provided. Please provide only one combination.");
        }
        this.jsonPathConfig = BasicJsonPathDefaultConfiguration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST}).build();
        this.attributeMapping = Attributes.getAttributeMapping((Settings)settings.getAsSettings("map_claims_to_user_attrs"));
    }

    public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) throws ElasticsearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(() -> this.extractCredentials0(request));
    }

    private AuthCredentials extractCredentials0(RestRequest request) throws ElasticsearchSecurityException {
        String subject;
        JwtToken jwt;
        String jwtString = this.getJwtTokenString(request);
        if (Strings.isNullOrEmpty((String)jwtString)) {
            return null;
        }
        try {
            jwt = this.jwtVerifier.getVerifiedJwtToken(jwtString);
        }
        catch (AuthenticatorUnavailableException e) {
            log.info((Object)e);
            throw new ElasticsearchSecurityException(e.getMessage(), RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
        }
        catch (BadCredentialsException e) {
            log.info("Extracting JWT token from " + jwtString + " failed", (Throwable)e);
            return null;
        }
        JwtClaims claims = jwt.getClaims();
        if (log.isTraceEnabled()) {
            log.trace("Claims from JWT: " + claims);
        }
        if ((subject = this.extractSubject(claims)) == null) {
            log.error("No subject found in JWT token");
            return null;
        }
        String[] roles = this.extractRoles(claims);
        if (log.isTraceEnabled()) {
            log.trace("From JWT:\nSubject: " + subject + "\nRoles: " + Arrays.asList(roles));
        }
        return AuthCredentials.forUser((String)subject).authenticatorType(this.getType()).backendRoles(roles).attributesByJsonPath(this.attributeMapping, (Object)claims).prefixOldAttributes("attr.jwt.", claims.asMap()).complete().build();
    }

    protected String getJwtTokenString(RestRequest request) {
        String jwtToken = request.header(this.jwtHeaderName);
        if (jwtToken != null && jwtToken.toLowerCase().startsWith("basic ")) {
            jwtToken = null;
        }
        if (this.jwtUrlParameter != null) {
            if (jwtToken == null || jwtToken.isEmpty()) {
                jwtToken = request.param(this.jwtUrlParameter);
            } else {
                request.param(this.jwtUrlParameter);
            }
        }
        if (jwtToken == null) {
            return null;
        }
        int index = jwtToken.toLowerCase().indexOf(BEARER);
        if (index > -1) {
            jwtToken = jwtToken.substring(index + BEARER.length());
        }
        return jwtToken;
    }

    protected String extractSubject(JwtClaims claims) {
        Object subjectObject;
        String subject = claims.getSubject();
        if (this.subjectKey != null) {
            subjectObject = claims.getClaim(this.subjectKey);
            if (subjectObject == null) {
                log.warn("Failed to get subject from JWT claims, check if subject_key '{}' is correct.", (Object)this.subjectKey);
                return null;
            }
            if (!(subjectObject instanceof String)) {
                log.warn("Expected type String for roles in the JWT for subject_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.subjectKey, subjectObject, subjectObject.getClass());
                subject = String.valueOf(subjectObject);
            } else {
                subject = (String)subjectObject;
            }
        } else if (this.jsonSubjectPath != null) {
            try {
                subjectObject = JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration()).parse((Object)claims.asMap()).read(this.jsonSubjectPath, new Predicate[0]);
                if (subjectObject == null) {
                    log.error("The subject is null: " + this.jsonSubjectPath);
                    return null;
                }
                if (subjectObject instanceof Collection) {
                    Collection subjectCollection = (Collection)subjectObject;
                    if (subjectCollection.size() == 0) {
                        log.error("The subject is empty: " + this.jsonSubjectPath);
                        return null;
                    }
                    if (subjectCollection.size() > 1) {
                        log.error("More than one subject was found. Failing authentication: " + subjectObject + "; " + this.jsonSubjectPath);
                        return null;
                    }
                    subject = String.valueOf(subjectCollection.iterator().next());
                } else {
                    subject = String.valueOf(subjectObject);
                }
            }
            catch (PathNotFoundException e) {
                log.error("The provided JSON path {} could not be found ", (Object)this.jsonSubjectPath);
                return null;
            }
        }
        if (subject != null && this.subjectPattern != null) {
            Matcher matcher = this.subjectPattern.matcher(subject);
            if (!matcher.matches()) {
                log.warn("Subject " + subject + " does not match subject_pattern " + this.subjectPattern);
                return null;
            }
            if (matcher.groupCount() == 1) {
                subject = matcher.group(1);
            } else if (matcher.groupCount() > 1) {
                StringBuilder subjectBuilder = new StringBuilder();
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    if (matcher.group(i) == null) continue;
                    subjectBuilder.append(matcher.group(i));
                }
                subject = subjectBuilder.length() != 0 ? subjectBuilder.toString() : null;
            }
        }
        return subject;
    }

    protected String[] extractRoles(JwtClaims claims) {
        if (this.rolesKey == null && this.jsonRolesPath == null) {
            return new String[0];
        }
        if (this.jsonRolesPath != null) {
            try {
                return Roles.split(JsonPath.using((Configuration)this.jsonPathConfig).parse((Object)claims.asMap()).read(this.jsonRolesPath, new Predicate[0]));
            }
            catch (PathNotFoundException e) {
                log.error("The provided JSON path {} could not be found ", (Object)this.jsonRolesPath);
                return new String[0];
            }
        }
        Object rolesObject = claims.getClaim(this.rolesKey);
        if (rolesObject == null) {
            log.warn("Failed to get roles from JWT claims with roles_key '{}'. Check if this key is correct and available in the JWT payload.", (Object)this.rolesKey);
            return new String[0];
        }
        return Roles.split(rolesObject);
    }

    protected abstract KeyProvider initKeyProvider(Settings var1, Path var2) throws Exception;

    public String getChallenge(AuthCredentials credentials) {
        return "Bearer realm=\"Search Guard\"";
    }

    private static Pattern getSubjectPattern(Settings settings) {
        String patternString = settings.get("subject_pattern");
        if (patternString == null) {
            return null;
        }
        try {
            return Pattern.compile(patternString);
        }
        catch (PatternSyntaxException e) {
            log.error("Invalid regular expression for subject_pattern: " + patternString, (Throwable)e);
            return null;
        }
    }
}

